#include "C:\\Program Files\\FED\\PIXIE\\Projects\\Bingo Expansion\\big_digits_Auto.h"

//#define debug
//
// functions
//

void pb_test();
void big_change();

//
// variables
//

unsigned char Ds[2], recbyte, test;
unsigned char pattern, digit, cur_digit, segment, seg_data, segments[12];
unsigned char time, pulsecount=0;
unsigned char old, new, new_digit[2][8], old_digit[2][8];
unsigned char i,j,k;

//
// Structures
//

struct flag1
{
 unsigned char big:1;
 unsigned char pulse:1;
 unsigned char flip:1;
 unsigned char seg_done:1;
 unsigned char e:1;
 unsigned char f:1;
 unsigned char g:1;
 unsigned char h:1;
};

flag1 flags1;


//
// for the C compiler
//

void UserInterrupt()
{
	// Insert your code here

 #asmline SETPCLATH UserIntReturn,-1  ; SETPCLATH for interrupt routine
 #asmline goto UserIntReturn	      ; Assembler - go back to interrupt routine
}


//
// Initialisation
//

void UserInitialise()
{
 ADCON1=1;
 TRISA=0x10;
 TRISB=0x00;
 TRISD=0x00;
   
 PORTA=PORTB=PORTD=0;
 
 if ((BigPort&(1<<BigBit))>>BigBit) flags1.big=1; // switch on 
 else flags1.big=0;
 
 if (flags1.big) 
  { 
   for (digit=0; digit<2; digit++)
    {
     for (segment=1; segment<8; segment++)
      {
       PORTD|=(0x01<<segment);
       PORTA|=(0x01<<digit);
       Wait(175);
       PORTD=0x00;
       PORTA=PORTA&0xfc;
      }
    }
   digit=0;
  }
 else digit=2;
  
 //
 // segment patterns (although display is common anode it is driven via Darlington pair
 // so patterns are inverted)
 //
 
 segments[0]=0x7e;
 segments[1]=0x0c;
 segments[2]=0xb6;
 segments[3]=0x9e;
 segments[4]=0xcc;
 segments[5]=0xda;
 segments[6]=0xfa;
 segments[7]=0x0e;
 segments[8]=0xfe;
 segments[9]=0xde;
 segments[10]=0x00;
 segments[11]=0x80;
 
 Ds[0]=Ds[1]=0;	//initial display
 
 OnPort|=(1<<OnBit);
}

//
// C thing
//

void UserLoop()
{
}

//
// Occurrence - Received a Byte
//

void receive()   
{
 if (GetRxSize()>0) // make sure something's in the buffer!!!!
  {
   if (WaitRx()=='S') 
    {Ds[0]=WaitRx(); // dummy first digit
     Ds[0]=WaitRx(); if (Ds[0]>9) Ds[0]=11;
     Ds[1]=WaitRx(); if (Ds[1]>9) Ds[1]=11;}
     
   else return;
 
   if ((Ds[0]==0)&&(Ds[1]==0)) {Ds[0]=11; Ds[1]=11;}
 
   if (flags1.big)		// big digits so set up segment matrix
    { 
     for (i=0; i<2; i++)	// for each digit
      {
       seg_data=segments[Ds[i]];	// segment conversion
       for (j=0; j<8; j++) 	// check each segment
        {
         if (seg_data&(0x01<<j)) new_digit[i][j]=1; // if seg bit is 1
         else new_digit[i][j]=0;
        }
      }
//     flags1.flip=flags1.seg_done=1; segment=1; digit=0;
     big_change(); 
    }
 }
}

void dm()
{
 if (flags1.big==0)
  {
   PORTA&=~(0x01<<digit);
   digit++; if (digit==4) digit=2;
   pattern=Ds[digit-2];
   PORTB=segments[pattern];
   PORTA|=(0x01<<digit);
  }
}


void big_change()
{
 for (digit=0; digit<2; digit++)
  {
   for (segment=1; segment<8; segment++)
    {
     old=old_digit[digit][segment];
     new=new_digit[digit][segment];
     if (new!=old)
      {
       PORTA|=(0x01<<digit);
       
       if (new==1) {PORTB|=(0x01<<segment); Wait(100);} //on
       else {PORTD|=(0x01<<segment); Wait(175);}	// or off
              
       PORTA=PORTA&0xfc;
       PORTB=0x00;
       PORTD=0x01;
      }
    }
  }
 for (i=0; i<2; i++) // copy new to old
  {for (j=1; j<8; j++) old_digit[i][j]=new_digit[i][j];}
}

